function P81_ii
% Problem 8.1 :	Nonlinear parametric pendulum
% Part ii. Stability

% Define some constants
omega0=1;       % Natural frequency of the pendulum
gamma=0.1;      % Damping coefficient
h=[0.39 0.41];  % Two amplitudes of forcing

% Define some parameters for using Runge-Kutta metod
tspan=[0 500];      % Time span to be obtained
theta0=[0.01,0];    % Initial conditions

% Choose time step smaller than 0.01 sec
optn=odeset('InitialStep',1e-2,'MaxStep',1e-2);

% Simulation with the amplitude of forcing smaller than critical value
[T1,Y1]=ode45(@(t,x) Npp(t,x,gamma,omega0,h(1)),tspan,theta0,optn);

% Simulation with the amplitude of forcing larger than critical value
[T2,Y2]=ode45(@(t,x) Npp(t,x,gamma,omega0,h(2)),tspan,theta0);

% Plot and compare simulation results
figure(1); 
subplot(2,1,1); plot(T1,Y1(:,1),'r'); grid on; axis tight; 
xlabel('\bfTime (Sec)'); ylabel('\bfAngle (Rad)');
title('\bfTrajectory of the Pendulum with \gamma>(h\omega_0)^2/16 (h=0.39)');
subplot(2,1,2); plot(T2,Y2(:,1),'b--'); grid on; axis tight; 
xlabel('\bfTime (Sec)'); ylabel('\bfAngle (Rad)');
title('\bfTrajectory of the Pendulum with \gamma<(h\omega_0)^2/16 (h=0.41)');
end

function dx=Npp(t,x,gamma,omega0,h)
% Describe nonlinear parametric pendulum motion
dx(1,1)=x(2);
dx(2,1)=-2*gamma*x(2)-omega0^2*(1+h*cos(2*omega0*t))*sin(x(1));
end